#ifndef MYWINDOW3_LIBRARIAN_FUNCTION_H_INCLUDED
#define MYWINDOW3_LIBRARIAN_FUNCTION_H_INCLUDED

#include<gtkmm.h>
#include "functions.h"
c_book::c_book(){
    set_position(Gtk::WIN_POS_CENTER);
    set_default_size(300, 100);
    set_title("CREATE A BOOK");

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    grid->set_column_spacing(10);
    vbox->add(*grid);

    Gtk::Label *lbl1 = Gtk::manage(new Gtk::Label("ENTER BOOK ID"));
    grid->attach(*lbl1, 0, 0, 1, 1);

    Gtk::Label *lbl2 = Gtk::manage(new Gtk::Label("ENTER BOOK NAME"));
    grid->attach(*lbl2, 0, 1, 1, 1);

    Gtk::Label *lbl3 = Gtk::manage(new Gtk::Label("ENTER AUTHOR NAME"));
    grid->attach(*lbl3, 0, 2, 1, 1);

    Gtk::Entry *txtfld1 = Gtk::manage(new Gtk::Entry());
    grid->attach(*txtfld1, 1, 0, 2, 1);

    Gtk::Entry *txtfld2 = Gtk::manage(new Gtk::Entry());
    grid->attach(*txtfld2, 1, 1, 2, 1);

    Gtk::Entry *txtfld3 = Gtk::manage(new Gtk::Entry());
    grid->attach(*txtfld3, 1, 2, 2, 1);

    Gtk::Button *blogin = Gtk::manage(new Gtk::Button("CREATE"));
    blogin->signal_clicked().connect(sigc::bind<Gtk::Entry*, Gtk::Entry*, Gtk::Entry*>(sigc::mem_fun(*this, &c_book::on_button_click), txtfld1,txtfld2,txtfld3));
    grid->attach(*blogin, 2, 4, 1, 1);

    vbox->show_all();
}
c_book::~c_book(){

}
void c_book::on_button_click(Gtk::Entry *txtfld1, Gtk::Entry *txtfld2,Gtk::Entry *txtfld3){
    FILE *fbook;
    fbook=fopen("BOOK.txt","a+");
    char b_id[30],b_name[30],a_name[30];

    copy_ustring(b_id,txtfld1->get_text());
    copy_ustring(b_name,txtfld2->get_text());
    copy_ustring(a_name,txtfld3->get_text());

    if(!search_bid(b_id,fbook)){
        FILE *fbook;
        fbook=fopen("BOOK.txt","a+");
        fprintf(fbook,"%s,%s,%s,0,\n",b_id,b_name,a_name);
        fclose(fbook);
        dialog("        Success !!      ");
        hide();
    }
    else{
        Gtk::MessageDialog dlg("ID already exists try again.", false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
        dlg.set_title("ERROR");
        dlg.run();
    }

}

m_book::m_book(){
    set_position(Gtk::WIN_POS_CENTER);
    set_default_size(300, 100);
    set_title("MODIFY BOOK");

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    grid->set_column_spacing(10);
    vbox->add(*grid);

    Gtk::Label *lbl1 = Gtk::manage(new Gtk::Label("ENTER BOOK ID"));
    grid->attach(*lbl1, 0, 0, 1, 1);

    Gtk::Label *lbl2 = Gtk::manage(new Gtk::Label("ENTER BOOK NAME"));
    grid->attach(*lbl2, 0, 1, 1, 1);

    Gtk::Label *lbl3 = Gtk::manage(new Gtk::Label("ENTER AUTHOR NAME"));
    grid->attach(*lbl3, 0, 2, 1, 1);

    Gtk::Entry *txtfld1 = Gtk::manage(new Gtk::Entry());
    grid->attach(*txtfld1, 1, 0, 2, 1);

    Gtk::Entry *txtfld2 = Gtk::manage(new Gtk::Entry());
    grid->attach(*txtfld2, 1, 1, 2, 1);

    Gtk::Entry *txtfld3 = Gtk::manage(new Gtk::Entry());
    grid->attach(*txtfld3, 1, 2, 2, 1);

    Gtk::Button *blogin = Gtk::manage(new Gtk::Button("MODIFY"));
    blogin->signal_clicked().connect(sigc::bind<Gtk::Entry*, Gtk::Entry*,Gtk::Entry*>(sigc::mem_fun(*this, &m_book::on_button_click), txtfld1,txtfld2,txtfld3));
    grid->attach(*blogin, 2, 3, 1, 1);

    vbox->show_all();
}
m_book::~m_book(){

}
void m_book::on_button_click(Gtk::Entry *txtfld1, Gtk::Entry *txtfld2,Gtk::Entry *txtfld3){
    FILE *fbook;
    fbook=fopen("BOOK.txt","a+");
    char b_id[30],b_name[30],a_name[30],new_mystring[100];
    copy_ustring(b_id,txtfld1->get_text());
    copy_ustring(b_name,txtfld2->get_text());
    copy_ustring(a_name,txtfld3->get_text());

    if(!search_bid(b_id,fbook)){
        Gtk::MessageDialog dlg("ID does not exist try again.", false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
        dlg.set_title("ERROR");
        dlg.run();
    }
    else{
        book_assemble(b_id,b_name,a_name,new_mystring);
        book_modify(b_id,b_name,a_name,new_mystring);
        dialog("Success !");
        hide();
    }
}
r_lib_book::r_lib_book(){
    set_position(Gtk::WIN_POS_CENTER);
    set_default_size(300, 100);
    set_title("REMOVE A BOOK");

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    grid->set_column_spacing(10);
    vbox->add(*grid);

    Gtk::Label *lbl1 = Gtk::manage(new Gtk::Label("ENTER BOOK ID"));
    grid->attach(*lbl1, 0, 0, 1, 1);

    Gtk::Entry *txtfld1 = Gtk::manage(new Gtk::Entry());
    grid->attach(*txtfld1, 1, 0, 2, 1);

    Gtk::Button *blogin = Gtk::manage(new Gtk::Button("REMOVE"));
    blogin->signal_clicked().connect(sigc::bind<Gtk::Entry*>(sigc::mem_fun(*this, &r_lib_book::on_button_click), txtfld1));
    grid->attach(*blogin, 2, 2, 1, 1);

    vbox->show_all();
}
r_lib_book::~r_lib_book(){

}

void r_lib_book::on_button_click(Gtk::Entry *txtfld1){

    FILE *fbook;
    fbook=fopen("BOOK.txt","r");
    char b_id[30];
    copy_ustring(b_id,txtfld1->get_text());

    if(!search_bid(b_id,fbook)){
        Gtk::MessageDialog dlg("ID does not exist!!.", false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
        dlg.set_title("ERROR");
        dlg.run();
    }
    else{

        if(!check_book(b_id)){
            fbook=fopen("BOOK.txt","a+");
            del_book(b_id,fbook);
            dialog("Success");
            hide();
        }
        else{
            Gtk::MessageDialog dlg("Book is issued\n Can't delete", false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
            dlg.set_title("ERROR");
            dlg.run();
        }
    }

}

v_lib_rec::v_lib_rec(){
    set_position(Gtk::WIN_POS_CENTER);
    set_default_size(500, 200);
    set_title("VIEW RECORDS");

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    vbox->add(*grid);

    Gtk::TreeView *treeview = Gtk::manage(new Gtk::TreeView);
    treeview->set_hexpand(true);
    treeview->set_vexpand(true);
    grid->attach(*treeview, 0, 0, 3, 1);

    refTreeModel = Gtk::ListStore::create(columns);
    treeview->set_model(refTreeModel);
    treeview->append_column("Sr. No.", columns.sr_no);
    treeview->append_column("Book ID", columns.b_id);
    treeview->append_column("Book Name", columns.b_name);
    treeview->append_column("Author Name", columns.a_name);
    treeview->append_column("Book Status", columns.b_status);

    FILE *fbook;
    fbook=fopen("BOOK.txt","r");
    char b_string[100]="",s1[30],s2[30],s3[30],s4[30];
     int i,j;
     while(!feof(fbook)){
        i=j=0;
		fgets(b_string,99,fbook);
		if(feof(fbook))
            break;
		for(i=0;b_string[j]!=',';s1[i]=b_string[j],i++,j++);
		s1[i]='\0';
		for(i=0,++j;b_string[j]!=',';s2[i]=b_string[j],i++,j++);
		s2[i]='\0';
		for(i=0,++j;b_string[j]!=',';s3[i]=b_string[j],i++,j++);
		s3[i]='\0';
		for(i=0,++j;b_string[j]!=',';s4[i]=b_string[j],i++,j++);
		s4[i]='\0';

        Gtk::TreeModel::Row row = *(refTreeModel->append());
        rowcount++;
        row[columns.sr_no] = rowcount;
        row[columns.b_id] = s1;
        row[columns.b_name] = s2;
        row[columns.a_name] = s3;
        if(strcmp(s4,"1")==0)
            row[columns.b_status] = "Issued";
        else
            row[columns.b_status] = "Available";
	}
	fclose(fbook);
    vbox->show_all();
}


v_lib_rec::~v_lib_rec(){

}
v_book_req::v_book_req(){
    set_position(Gtk::WIN_POS_CENTER);
    set_default_size(500, 200);
    set_title("VIEW BOOK REQUESTS");

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    vbox->add(*grid);

    Gtk::TreeView *treeview = Gtk::manage(new Gtk::TreeView);
    treeview->set_hexpand(true);
    treeview->set_vexpand(true);
    grid->attach(*treeview, 0, 0, 3, 1);

    refTreeModel = Gtk::ListStore::create(columns);
    treeview->set_model(refTreeModel);
    treeview->append_column("Sr. No.", columns.sr_no);
    treeview->append_column("Book Name", columns.b_name);
    treeview->append_column("Author Name", columns.a_name);


    Gtk::Button *button = Gtk::manage(new Gtk::Button("CLEAR"));
    button->signal_clicked().connect(sigc::mem_fun(*this, &v_book_req::on_button_click));
    grid->attach(*button, 1, 1, 1, 1);

    Gtk::Button *button1 = Gtk::manage(new Gtk::Button("QUIT"));
    button1->signal_clicked().connect(sigc::mem_fun(*this, &v_book_req::on_button1_click));
    grid->attach(*button1, 1, 2, 1, 1);

    FILE *fbrq;
    fbrq=fopen("book_req.txt","r");
    char b_string[100]="",s1[30],s2[30],s3[30];
     int i,j;
     while(!feof(fbrq)){
        i=j=0;
		fgets(b_string,99,fbrq);
		if(feof(fbrq))
            break;
		for(i=0;b_string[j]!=',';s1[i]=b_string[j],i++,j++);
		s1[i]='\0';
		for(i=0,++j;b_string[j]!=',';s2[i]=b_string[j],i++,j++);
		s2[i]='\0';
		for(i=0,++j;b_string[j]!=',';s3[i]=b_string[j],i++,j++);
		s3[i]='\0';

        Gtk::TreeModel::Row row = *(refTreeModel->append());
        rowcount++;
        row[columns.sr_no] = rowcount;
        row[columns.b_name] = s2;
        row[columns.a_name] = s3;

	}
	fclose(fbrq);
    vbox->show_all();

}
void v_book_req::on_button_click(){
    FILE *fbrq;
    fbrq=fopen("book_req.txt","w");
    fclose(fbrq);
    Gtk::MessageDialog dlg("Success!", false, Gtk::MESSAGE_INFO, Gtk::BUTTONS_OK, true);
    dlg.set_title("SUCCESS");
    dlg.run();
    hide();
    struct bookreq{
        v_book_req *ptr;
    };
    bookreq *ptr = new bookreq;
    ptr->ptr = new v_book_req;
    ptr->ptr->show();
}

void v_book_req::on_button1_click(){
    hide();

}

v_book_req::~v_book_req(){}
v_lib_rar::v_lib_rar(){
    set_position(Gtk::WIN_POS_CENTER);
    set_default_size(500, 200);
    set_title("RULES AND REGULATIONS");

    //VIRTUAL BOX

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    //ADDING A GRID TO THE VBOX

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    grid->set_column_spacing(10);
    vbox->add(*grid);

    //A LABEL AT THE TOP

    Gtk::Label *heading1 = Gtk::manage(new Gtk::Label(""));
    heading1->set_hexpand(true);
    grid->attach(*heading1, 0, 0, 1, 1);

     Gtk::Label *heading2 = Gtk::manage(new Gtk::Label("RULES AND REGULATIONS"));
    heading2->set_hexpand(true);
    grid->attach(*heading2, 1, 0, 1, 1);

     Gtk::Label *heading3 = Gtk::manage(new Gtk::Label(""));
    heading3->set_hexpand(true);
    grid->attach(*heading3, 2, 0, 1, 1);

    Gtk::Label *heading4 = Gtk::manage(new Gtk::Label("1. Members can isue only one book at a time\n2. The books should be handled carefully. Any mishandling if spotted will directly cause loss of membership and fine.\n3. The users must bring a valid ID card and the user should never forget user ID and Pasword.\n4. Under no circumstances should any book be taken out of the library without checking it out.\n     However in case of any problem the user should approach the admin for any action to be taken.\n5. Guest users are not allowed to check out any book. However they are welcome to read in the library.\n6.Checking out and Deposition of books will be handled by the librarian and the administrator will address customer issues and feedbacks."));
    heading4->set_hexpand(true);
    grid->attach(*heading4, 1, 2, 1, 1);

    vbox->show_all();
}
v_lib_rar::~v_lib_rar(){

}

#endif
